#ifdef GL_ES
attribute vec3 inVertex;
attribute vec3 inNormal;
attribute vec2 inTexCoord0;
attribute vec4 inTexCoord1;

varying float specular;
varying float diffuse;
varying vec2 vTexCoord;
#else
in vec3 inVertex;
in vec3 inNormal;
in vec2 inTexCoord0;
in vec4 inTexCoord1;

out float specular;
out float diffuse;
out vec2 vTexCoord;
#endif
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelViewMatrixInverse;

uniform vec3 lightSource1;
uniform vec3 lightSource1HV;
uniform vec3 lightSource2;
uniform vec3 lightSource2HV;

uniform float brightness;

void main()
{
    vTexCoord = inTexCoord0;
    
    vec3 vTangent = inTexCoord1.xyz;
    vec3 vBitangent = cross(inNormal, vTangent) * inTexCoord1.w;
    mat3 mvmi;
    mvmi[0] = modelViewMatrixInverse[0].xyz;
    mvmi[1] = modelViewMatrixInverse[1].xyz;
    mvmi[2] = modelViewMatrixInverse[2].xyz;
    
    vec3 hV = mvmi * normalize(lightSource1HV + lightSource2HV);
    
    vec3 halfVector;
    halfVector.x = dot(vTangent, hV);
    halfVector.y = dot(vBitangent, hV);
    halfVector.z = dot(inNormal, hV);
    
    specular = pow(max(0.0, dot(vec3(0, 0, 1), normalize(halfVector))), 8.0) * 0.35;
    diffuse = (max(0.0, dot(inNormal, lightSource1)) + max(0.0, dot(inNormal, lightSource2))) * brightness * 0.75;

    gl_Position = projectionMatrix * modelViewMatrix * vec4(inVertex, 1.0);
}
